
BEGIN {
    FS = "|"
}

{
    split($2, name, / +/)
    star_name  = name[1]
    cons_abbrv = name[2]

    # In two cases a variable star is actually a pair of variables. The constellation name is
    # then extended to, e. g., CasA*/CasB* which is longer than three characters. We will
    # ignore those cases. Also there are cases where the constellation name is '1' or '2'. We
    # will ignore those as well.
    if (length(cons_abbrv) == 3) {

        ra_hrs  = substr($3, 1, 2)
        ra_min  = substr($3, 3, 2)
        ra_sec  = substr($3, 5, 5)
        ra      = ra_hrs + ra_min/60 + ra_sec/3600

        dec_deg = substr($3, 11, 3)
        dec_min = substr($3, 14, 2)
        dec_sec = substr($3, 16, 4)
        dec_frac= dec_min/60 + dec_sec/3600
        if (dec_deg + 0 < 0) {
            dec = dec_deg - dec_frac
        }
        else {
            dec = dec_deg + dec_frac
        }

        kind = $4
        max  = $5
        min  = $6
        var_period = $11

        # Some records have a minimum of zero or contain text such as "< 16.0" which looks like
        # zero when converted to a number by awk. (presumably these records are for nova with
        # unidentified progenitor stars). Let's ignore those.
        if (min + 0 > 0.0) {
            printf "INSERT INTO star VALUES\n  ('%s', '%s', %f, %f, %f, %f, '%s', %f, NULL);\n",
                star_name, cons_abbrv, ra, dec, max, min, kind, var_period
        }
    }
}
