---------------------------------------------------------------------------
-- FILE      : star-tables-simple.sql
-- SUBJECT   : Variable star database
-- PROGRAMMER: (C) Copyright 2022 by Peter C. Chapin
--
-- Please send comments or bug reports to
--
--      Peter Chapin
--      Department of Computer Information Systems
--      Vermont Technical College
--      Williston, VT 05495
--      pchapin@vtc.edu
---------------------------------------------------------------------------

-- I want to be sure only legal constellation abbreviations are used. Since there are quite a
-- few of them, I will store the legal abbreviations in a table and use referential integrity
-- to check validity.
--
CREATE TABLE constellation(
        abbrev          CHAR(3) PRIMARY KEY,
        name            VARCHAR(20), -- 'Triangulum Australe' has 19 characters.
        genitive        VARCHAR(20)  -- 'Trianguli Australis' has 19 characters.
);

CREATE TABLE star(
        name            CHAR(5),
        const           CHAR(3) REFERENCES constellation(abbrev),
        ra              NUMERIC(8,6) CHECK(  0 <= ra  AND ra  <  24), -- Right ascension
        dec             NUMERIC(8,6) CHECK(-90 <= dec AND dec <= 90), -- Declination
        max_bright      NUMERIC(6,3),  -- The smaller the value, the brighter the star.
        min_bright      NUMERIC(6,3),  -- ... a larger number than max_bright.
        kind            CHAR(10),      -- The "kind" (or type) of variable.
        var_period      NUMERIC(7,3),  -- Period of variability in days.
        notes           VARCHAR(80),   -- Free form text with additional information.
        PRIMARY KEY(name, const)       -- For example: ('RR','Lyr')
);
