
package edu.vtc.cis3030

import io.StdIn

/**
 * This program implements a simple, stack-based interval calculator. At the prompt you can
 * enter either an interval (in a format acceptable to Interval.parseInterval) or one of the
 * usual operator symbols.
 */
object Hw07 {

  def main(args: Array[String]): Unit = {
    var line = ""
    while ({ print("> "); line = StdIn.readLine(); line != "" }) {
      line match {
        case "+" =>
          // Handle addition.
          val right = IntervalStack.pop()
          val left = IntervalStack.pop()
          val result = left + right
          println(result)
          IntervalStack.push(result)

        case "-" =>
          // Handle subtraction.
          val right = IntervalStack.pop()
          val left = IntervalStack.pop()
          val result = left - right
          println(result)
          IntervalStack.push(result)

        case "*" =>
          // Handle multiplication.
          val right = IntervalStack.pop()
          val left = IntervalStack.pop()
          val result = left * right
          println(result)
          IntervalStack.push(result)

        case "/" =>
          // Handle division.
          val right = IntervalStack.pop()
          val left = IntervalStack.pop()
          val result = left / right
          println(result)
          IntervalStack.push(result)

        case _ =>
          // Handle the case of an Interval being input.
          IntervalStack.push(Interval.parseInterval(line))
      }
    }
  }

}

