
package edu.vtc.cis3030

/**
 * This module implements a stack of Interval objects. It is used by the interval calculator.
 * It is complete and should not require any additional modifications. Note that the methods
 * of the IntervalStack have side effects; the stack is mutable.
 */
object IntervalStack {

  private var stack: List[Interval] = List()

  /**
   * Push an Interval onto the stack.
   * @param value The value to push.
   */
  def push(value: Interval): Unit = {
    stack = value :: stack
  }

  /**
   * Pop and return the Interval on the top of the stack.
   * @return The old top Interval.
   */
  def pop(): Interval = {
    require(stack.length > 0, "attempt to pop an empty interval stack")

    val value = stack.head
    stack = stack.tail
    value
  }

}
