
#include <assert.h>
#include <stdlib.h>
#include "BinaryTree.h"

struct BinaryTreeNode {
    const void *data;
    struct BinaryTreeNode *parent;
    struct BinaryTreeNode *left;
    struct BinaryTreeNode *right;
};


void BinaryTree_construct( BinaryTree *object, SWO_t strict_weak_ordering )
{
    assert( object != NULL );

    object->root = NULL;
    object->count = 0;
    object->comes_before = strict_weak_ordering;
}


static void BinaryTree_destroy_node( BinaryTreeNode *node )
{
    if( node == NULL ) return;
    BinaryTree_destroy_node( node->left );
    BinaryTree_destroy_node( node->right );
    free( node );
}


void BinaryTree_destroy( BinaryTree *object )
{
    assert( object != NULL );

    BinaryTree_destroy_node( object->root );
}


size_t BinaryTree_size( const BinaryTree *object )
{
    return object->count;
}


static const void *BinaryTree_min_node( const BinaryTreeNode *node )
{
    assert( node != NULL );

    if( node->left == NULL ) return node->data;
    return BinaryTree_min_node( node->left );
}


const void *BinaryTree_min( const BinaryTree *object )
{
    assert( object != NULL );

    if( object->root == NULL ) return NULL;
    return BinaryTree_min_node( object->root );
}


static const void *BinaryTree_max_node( const BinaryTreeNode *node )
{
    assert( node != NULL );

    if( node->right == NULL ) return node->data;
    return BinaryTree_max_node( node->right );
}


const void *BinaryTree_max( const BinaryTree *object )
{
    assert( object != NULL );

    if( object->root == NULL ) return NULL;
    return BinaryTree_max_node( object->root );
}


static const void *BinaryTree_lookup_node( const BinaryTreeNode *node, SWO_t comes_before, const void *item )
{
    assert( node != NULL && item != NULL );
    
    // Is the item in the left direction?
    if( comes_before( item, node->data ) ) {
        if( node->left != NULL )
            return BinaryTree_lookup_node( node->left, comes_before, item );
        else
            return NULL;
    }

    // Is the item in the right direction?
    if( comes_before( node->data, item ) ) {
        if( node->right != NULL )
            return BinaryTree_lookup_node( node->right, comes_before, item );
        else
            return NULL;
    }

    // Did we find the item we are looking for?
    return node->data;
}


const void *BinaryTree_lookup( const BinaryTree *object, const void *item )
{
    assert( object != NULL && item != NULL );

    if( object->root == NULL ) return NULL;
    return BinaryTree_lookup_node( object->root, object->comes_before, item );
}


void BinaryTree_insert( BinaryTree *object, const void *item )
{

}


void BinaryTree_delete( BinaryTree *object, const void *item )
{

}


static int BinaryTree_invariant_node( const BinaryTreeNode *node, SWO_t comes_before )
{
    int count = 0;

    if( node == NULL ) return count;

    count += BinaryTree_invariant_node( node->left, comes_before );
    count += 1;
    count += BinaryTree_invariant_node( node->right, comes_before );
    return count;
}


int BinaryTree_invariant( const BinaryTree *object )
{
    return ( BinaryTree_invariant_node( object->root, object->comes_before ) == object->count );
}
