
#ifndef BINARYTREE_H
#define BINARYTREE_H

typedef int  ( *SWO_t )( const void *, const void * );

struct BinaryTreeNode;

typedef struct {
    struct BinaryTreeNode *root;
    size_t count;
    SWO_t  comes_before;
} BinaryTree;

typedef struct {
    BinaryTree *object;
    struct BinaryTreeNode *current;
} BinaryTreeIterator;

// Lifecycle operations...
void        BinaryTree_construct( BinaryTree *object, SWO_t strict_weak_ordering );
void        BinaryTree_destroy( BinaryTree *object );

// Non-modifying tree operations...
size_t      BinaryTree_size( const BinaryTree *object );
const void *BinaryTree_min( const BinaryTree *object );
const void *BinaryTree_max( const BinaryTree *object );
const void *BinaryTree_lookup( const BinaryTree *object, const void *item );

// Modifying tree operations...
void        BinaryTree_insert( BinaryTree *object, const void *item );
void        BinaryTree_delete( BinaryTree *object, const void *item );

// Debugging operations...
int         BinaryTree_invariant( const BinaryTree *object );

// Iterator operations...
BinaryTreeIterator BinaryTree_begin( BinaryTree *object );
BinaryTreeIterator BinaryTree_end( BinaryTree *object );
int                BinaryTree_equal_iterator( BinaryTreeIterator it_1, BinaryTreeIterator it_2 );
BinaryTreeIterator BinaryTree_next( BinaryTreeIterator it );
const void        *BinaryTree_get( BinaryTreeIterator it );

#endif

