# NoComment

This program demonstrates using deterministic finita automata (DFAs) to strip comments from C,
C++, and D programs. The object CommentStrip.scala contains an imperative implementation that
can also handle D's nested /+ ... +/ comments. The object CommentStripFunction contains a less
feature-rich functional implementation. Both objects have suitable main methods, but the file
Main.scala contains a top-level main method that can run either version depending on its command
line arguments.

Build the program with sbt as follows:

    $ sbt compile
    
It is recommended to run the program with the usual Scala runner rather than from inside SBT.
This is because SBT's buffering behavior does not interact well with the program's output.
For example:

    $ scala -cp target/scala-3.6.2/classes -M noComment -- imperative comment-test.d
    
This runs the top-level main function on the D sample program using the "imperative" selector.
If you want to try the functional version use the "functional" selector. See the source code for
the top-level main in Main.scala for more information.

