
NOTES
=====

Profiling
---------

There are two ways to profile this program using standard GNU tools: `gprof` and `gcov`. The
`gprof` tool is a function-level profiler so it only shows results on a per-function basis. This
might be fine in some situations, but in this case we want line-level information so we'll need
to use `gcov`. Note that `gcov` only counts the number of times each line executes. It does not
measure times.

I chose to profile the debug configuration. That choice is controversial. It is really the
performance of the release version we care about, so it makes sense to profile that version
instead. In fact, the debug version may have bottlenecks that are completely removed by the
optimizer and thus spurious insofar as our ultimate goal is concerned.

However, it will be easier to interpret the output of the profiling tools if we profile the
debug version. Since we are mostly just interested in a general feel for what is taking most of
the time, I think profiling the debug version will be fine in this case.

Note that the profiling results are also easier to interpret if all the functions are public.
Thus in this project, the internally linked (`static`) functions are made externally linked to
facilitate analysis.

Using gprof
-----------

In "Project Properties" under the "C/C++ Build" select "Settings." From there you can expand the
options for the "Cygwin C compiler" and select "Debugging." Turn on the "Generate gprof
information" option. Clean and build the project (the clean ensures that all object files will
be rebuilt).

Run the executable and then do:

    $ gprof GaussianC-VLA.exe gmon.out > profiling-results.txt
    
This writes the profiling report to `profiling-results.txt`.

Using gconv
-----------

In "Project Properties" under the "C/C++ Build" select "Settings." From there you can expand the
options for the "Cygwin C compiler" and select "Debugging." Turn on the "Generate gconv
information" option. Clean and build the project (the clean ensures that all object files will
be rebuilt).

Run the executable and then do:

    $ gcov gaussian.c
    
This produces a report for that particular source file based on the data generated by the last
run of the program. View the file `gaussian.c.gcov` to review the information.
