
README
======

This example illustrates the gcov code coverage tool. There are several steps to using gcov.

1. First include the -ftest-coverage and -fprofile-arcs options on gcc when you compile your
   code. These options cause the compiler to instrument your program with additional
   instructions so that, when run, the program will output the necessary data for gcov. Note
   that this means your program will run (somewhat) more slowly than usual.
   
   The -ftest-coverage option provides instrumentation for counting the number of times each
   line of your program executes. The -fprofile-arcs option provides instrumentation for
   counting the number of times each branch goes in each of its possible directions. (Think
   "arcs" or edges in the control flow graph).
   
2. Run the executable file normally. Typically gcov is used to explore code coverage during
   testing as a way of evaluating the quality of the test suite. However, it can also be used as
   a profiling tool during "normal" runs to count the number of times each line executes and
   thus highlight areas that might profit from optimization. Note that since it is necessary to
   run the program to get analysis results, gcov is a kind of dynamic analysis.
   
3. Use the gcov program itself on a particular source file. This causes gcov to read the data
   files left by the running program. It then outputs a new source file (with a .gcov extension)
   that contains the results of the analysis. Lines prefixed by a number have executed that
   number of times. Lines prefixed by ##### have not executed at all. The gcov tool has many
   options that cause it to output additional information.
   
