
#include <CUnit/CUnit.h>
#include <CUnit/CUCurses.h>
#include <stdio.h>
#include <stdlib.h>

#include "string_tests.h"

int main( void )
{
    int exit_status = EXIT_SUCCESS;

    CU_pSuite str_suite;
    CU_pTest  str_tests[3];

    if( CU_initialize_registry( ) != CUE_SUCCESS ) {
        printf("Error initializing the CUnit registry!\n");
        exit_status = EXIT_FAILURE;
    }
    else {
        str_suite     = CU_add_suite( "String Tests", NULL, NULL );
        str_tests[0]  = CU_add_test( str_suite, "Construction Test", str_construction );
        str_tests[1]  = CU_add_test( str_suite, "Prepend Test", str_prepend );
        str_tests[2]  = CU_add_test( str_suite, "At Test", str_at );

        CU_curses_run_tests( );
        CU_cleanup_registry( );
    }
    return exit_status;
}
